export const matchVariation = (productDetails, variationData) => {
    const variation = {
        success: false,
        value: {},
    };
    if (Object.keys(variationData).length == 0) {
        return variation;
    } else {
        const newUserGiverVariation = { ...variationData };

        const { variations, attribute_values } = productDetails?.data;
        for (const key in variationData) {
            if (attribute_values[key]) {
                for (let k in attribute_values[key]) {
                    if (
                        attribute_values[key][k]?.value?.toLowerCase() ==
                        variationData[key]?.toLowerCase()
                    ) {
                        newUserGiverVariation[key] =
                            attribute_values[key][k]?.id;
                    }
                }
            }
        }

        const changedVariationAttributeKey = {};
        for (let key in newUserGiverVariation) {
            changedVariationAttributeKey[`attribute_${key}`] =
                newUserGiverVariation[key];
        }

        for (let key in variations) {
            let isMatch = Object.keys(changedVariationAttributeKey).every(
                (k) => {
                    return (
                        variations[key]?.attributes[k] ==
                            changedVariationAttributeKey[k] ||
                        "" == variations[key]?.attributes[k]
                    );
                }
            );
            if (isMatch && Object.values(variationData).every((i) => i)) {
                variation.success = true;
                variation.value = variations[key];
            }
        }
        return variation;
    }
};
